#rem
MobileLoggerTx.bas. Mods to Mobile_Logger_3.bas for 6-segment altitude linearization
John Saunders 11/18/2013 ;corrected minus flag persistance.
Added voltage check before recording.
Added check for valid baro value on first record after init	
11/25/2013: Header is recorded each boot - Mobile Logger powered only when car is running
Added clock start code in adjust time when adjusting minute
8/12/2014 Changed mode because of knob index
5/19/2015 New power module 2/7/2018 Transmit instead of probe 5/3/2018 settable transmit rate
8/24/2018 Transmit altitude 5th. 10/8/2018 output padded (29+1 characters).12/14/2018 added 152-153
#endrem

#picaxe 18M2

'Data Ports I/O
symbol TxPort		 = C.1	
symbol RTCOut        = C.6	'Data to the RTCt

'Input ports
symbol ModeSwitch    = C.0	'12-position switch with analog output
symbol SDResponse    = B.2	'From the Secure Digital chip interface
symbol MeasValuePort = B.3	'The supply voltage after divide by 5 attenuator
symbol RTCIn         = PinC.6	'Data from the RTC
symbol Baro          = B.1	'Barometer Amplifier output
symbol AdjustSW      = B.7	'0 = Down Switch,90 = Up switch, 255 = both off
symbol RecordSW      = PinC.5	'0=Record ON, 1 = Record Off

'Output ports
symbol DisplayNotCE  = B.0	'Enables the MC14489 LED display Driver when LOW
symbol Clock         = B.6	'Common clock for the DS1302 RTC and the MC15589 LED Driver
symbol SDCommand     = B.5	'To the Secure Digital chip interface	
symbol RTCEn         = C.7 	'DS1302 RTC chip enable when HIGH
symbol DisplayData   = C.2	'Data to MC14489 LED display Driver
symbol Sync          = B.4	'For the Humidity Sensor
symbol Test          = C.3

'Variables 
symbol Old_sec_phase		= bit0	
symbol MinusFlag	= Bit1
symbol BaroFlag     = Bit2	'Pressure measurement complete
symbol MinuteFlag   = Bit3	'At minute change
symbol HeaderFlag   = Bit4	'Signal recording a header instead of the data at midnight
symbol LSBFst       = Bit5  'If 1, use the MaskAddresses starting at 8 in the EEPROM
symbol BaroReady    = Bit6  'Avoids initial false barometer reading
symbol Bright       = Bit7	'Mostly bright
symbol Char         = B1	'Used for parameters
symbol Index        = B2	'General use
symbol Mode         = B3	'Standby,Input Volts,Time,Date,Probe Temp,Internal Temp,Humidity,Altitude,Barometric Pressure,Year,Countdown,Elapsed Time
symbol Scratch      = B4	'Used only locally for control structures
symbol Digit        = B5	'General use for data
symbol Mask         = B6	'Used in low-level subroutines
symbol BitPos       = B7	'Used in low-level subroutines
symbol Limit        = B8	'For AdjTimeDate, also global use in Standby
symbol DPCode       = B9	'First 3 bits of first hex sent to the display
symbol OldMin       = B10	'The value of BCD seconds on the last main loop
symbol DSAddr       = B11   'DS1302 address
symbol MaskAddr     = B12	'For use only in SendToRTC, GetByte, and SendByte
symbol StandbyCount = B13	'Used to show standby dot movement
symbol AltRange     = B14	'0-5
symbol RTCData      = B15	'Used only in RTC shift sub-procedures
symbol BaroCount    = B16	'Used to accumulate values for both altitude and barometric pressure
symbol UpDown       = B17	'UpDown Switches value
symbol RawAltitude  = W10	'Uncorrected Altitude sum
symbol BaroValue    = W11	'Accumulates pressure sensor readings
symbol AnalogValue  = W12	'Parameter for DisplayAnalog
symbol MeasValue    = W13	'Measured temperature

symbol Tx_sec_Count	= b18


'Pressure constants
symbol BaroMult      = 33
symbol BaroDiv       = 25
symbol BaroSetting   = 1759

'Display Constants
symbol Cmd4MSB       = %1100	'First nibble to be sent
symbol TwoDigitCmd   = %1101
symbol ThreeDigitCmd = %0111	'Second nibble-Left digit is special decode: 0 = blank, 13 = minus sign
symbol FourDigitCmd  = %0011	'Second nibble
symbol AllAlphaCmd   = %1111	'Second nibble
symbol DPNone        = 0	'Third nibble
symbol DP2           = 3	'Third nibble	
symbol DP3           = 4	'Third nibble	
symbol DPAll         = 7	'Third nibble	
symbol Dash		   = 13	'Displays a '-' in Standby

'Voltage minimun
symbol MinVolts      = 400	'8 volts to start recording

'EEPROM
symbol AltAdjustAddr   = 16		
symbol AltOffsetAddr	= 17
symbol AltCrossoverAddr = 29
symbol Tx_dur_addr		= 39

DATA 0,(128,64,32,16,8,4,2,1)		'For the MC14489 and humidity, MSB first
DATA 8,(1,2,4,8,16,32,64,128)		'For the DS1302 time LSB is first
DATA AltAdjustAddr ,(128)			'Altitude Adjustment

rem Measured amplifier gain
DATA AltOffsetAddr,($C5,$2B,$2B,$2F,$C9,$31,$BD,$33,$2F,$35,$15,$36)	'Altitude offset less bias and divided by 10, ranges 0-5
DATA AltCrossoverAddr,($66,3,$9E,2,$FE,1,$68,1,$E6,0)		'Altitude crossover less bias and divided by 2
rem Altitudes: 1900,4000,5700,7700,9500 (Home is 361 feet)
DATA Tx_dur_addr,(0,255,120,60,25,10,5,2)

'DS1302 Read Addresses (except WP;write only) -  subtract one for the write address
symbol RTCSec           = $81	
symbol RTCMin           = $83
symbol RTCHour          = $85
symbol RTCDate          = $87
symbol RTCMonth         = $89
symbol RTCDay           = $8B
symbol RTCYear          = $8D
symbol RTCWP            = $8E	'Write protect, set to 0 to write, $80 to protect
symbol RTCTC            = $90	'Trickle Charge - set to 0 for Li cell
symbol RAMBurst         = $FE	'Command to put Incoming data into RAM at $C1
symbol HumAddr          = $C3	'This is the integer value, the decimal is 2 higher
symbol TempAddr         = $C7	'This is the integer value, the decimal is 2 higher
symbol CheckAddr        = $CB
symbol OldDateAddr      = $F1	'To trigger header recording       
symbol Preclock         = 4		'The number of clock pulses to send before the Humidity Sensor output is enabled

'Scratchpad Addresses (asii)
symbol YearMSB          = 28
symbol HourMSB          = 34
symbol HourLSB          = 35
symbol MinMSB           = 36
symbol DateMSB          = 32
symbol MonthMSB         = 30
symbol ChkLSB			= 40
symbol ChkMSB			= 41
symbol VoltLSB			= 42
symbol VoltMSB          = 45
symbol HumLSB           = 46
symbol HumMSB           = 49
symbol TempMSB          = 53
symbol TempLSB          = 50
symbol AltLSB           = 58
symbol AltMSB           = 61
symbol Alt5th			= 62		'Only on recording and transmittimg
symbol BaroMSB          = 57
symbol BaroLSB          = 54

init:

SETFREQ m16
LOW Clock
LOW RTCEn
LOW Test
LOW TxPort
HIGH DisplayNotCE 
LOW Sync
LET MinuteFlag = 0			'Off	
LET HeaderFlag = 1		'Record the header each boot
LET BaroFlag   = 0
LET BaroReady  = 0

'No trickle Charge and disallow RTC writes
For Scratch = 0 TO 1
	LOOKUP Scratch,(RTCTC,RTCWP),DSAddr
	LOOKUP Scratch,($00,$80),Digit
	GOSUB SendByte
NEXT Scratch
HIGH SDCommand 
PAUSE 10
SEROUT SDCommand,T9600_16,("S 1 5",13)	'Set timeout for the SD writer to 50 ms
SERIN SDResponse,T9600_16,(">")

main:
LET MinusFlag = 0
'Check for new mode
INPUT ModeSwitch
ADCCONFIG 0		'Ref is power supply
READADC   ModeSwitch,Digit
LET Scratch = 8
DO WHILE Digit > Scratch
	LET Scratch = Scratch + 8
LOOP 
LET Mode = Scratch/16
INPUT AdjustSW
READADC   AdjustSW,UpDown

'Check for adjustments: off = 255,up = 90, down = 0
IF UpDown < 128 THEN
	SELECT Mode
		CASE 0										'Time
			IF RecordSW = 0 THEN
				LET DSAddr = RTCHour
				LET Limit = 23
			ELSE
			'Clock Start
				LET DSAddr = RTCSec - 1
				LET Digit = 0
				GOSUB SendByte
				LET DSAddr = RTCMin
				LET Limit = 59
			ENDIF
			GOSUB AdjTimeDate
		CASE 1										'Date
			IF RecordSW = 0 THEN
				LET DSAddr = RTCMonth
				LET Limit = 11    
			ELSE
				LET DSAddr = RTCDate
				LET Limit = 30
			ENDIF
			GOSUB AdjTimeDate
		CASE 2											'Transmit period
			READ Tx_dur_addr,index
			IF  UpDown < 45 THEN
				IF index > 0 THEN
					DEC index
				ELSE
					LET index = 6
				ENDIF
			ELSE
				IF index < 6 THEN
					INC index
				ELSE
					LET index = 0
				ENDIF
			ENDIF
			WRITE Tx_dur_addr,index
			LET Scratch = Tx_dur_addr+index + 1
			READ Scratch,Tx_sec_count
		CASE 5	'Altitude
			READ AltAdjustAddr, digit
			IF UpDown > 45 THEN
				INC digit
			ELSE	
				DEC digit
			ENDIF
			WRITE AltAdjustAddr, digit
		CASE 7	
			LET DSAddr = RTCYear
			LET Limit = 99
			GOSUB AdjTimeDate
		CASE 8	'Reset
			IF UpDown > 45 THEN Init		
			WRITE AltAdjustAddr,128	'Reset Altitude Adjustments to center
			
	ENDSELECT
ENDIF

'Get current time
GOSUB GetDateTime			'Digit contains minutes

IF Digit <> OldMin OR HeaderFlag = 1 THEN		'Programs running once per minute
	LET OldMin = Digit
	GOSUB GetHumidity
	LET MinuteFlag = 1	'Lights the LED and makes a recording
ENDIF


LET DSAddr = RTCSec
GOSUB GetByte
LET Digit = Digit & $01
IF Digit <> Old_sec_phase THEN
	LET Old_sec_phase = Digit
	IF Tx_sec_count > 0 THEN
		DEC Tx_sec_count
	ELSE
		READ Tx_dur_addr, Index
		LET Scratch = Tx_dur_addr+ Index + 1
		READ Scratch,Tx_sec_count
		GOSUB Transmit
	ENDIF
ENDIF

'Measure atmospheric pressure
GOSUB GetPressure

LET Bright = 1


'Mode-Dependent Programs   -------------------------------------------------------------
BRANCH Mode,(TOD,Date,Tx_period,Temp,Humidity,Altitude,Barometer,Year,Range,AltAdjust,Standby,Volts)

Standby:
IF StandbyCount > 5 THEN
	LET StandbyCount = 2
ELSEIF BaroCount = 0 THEN
	INC StandbyCount
ENDIF
LET DPCode = StandbyCount 
LET AnalogValue = Dash
LET Char = AllAlphaCmd
LET Bright = 0
GOTO RecCheck

Tx_period:
LET analogvalue = Tx_sec_count
LET char = ThreeDigitCmd
GOSUB DisplayNumber
GOTO Record


Volts:	'54 ms
LET Bptr = VoltMSB
GOSUB Ascii2BCD
IF AnalogValue < 4096 THEN
	LET Char = ThreeDigitCmd
ELSE
	LET Char = FourDigitCmd
ENDIF
LET DPCode = DP2
GOTO RecCheck


TOD:	'Time of day
LET Bptr = HourMSB
IF @bptr = "1" OR @bptr = "2" THEN
	LET Char = FourDigitCmd
ELSE
	LET Char = ThreeDigitCmd
ENDIF
FOR Scratch = 0 TO 3
	LET Digit = @bptrinc - "0"
	LET AnalogValue = 16*AnalogValue + Digit
NEXT
LET DPCode = DP2
GOTO RecCheck

Date:	'86 ms
LET Bptr = MonthMSB
LET AnalogValue = 0
FOR Scratch = 0 TO 3
	LET Digit = @bptrinc - "0"
	LET AnalogValue = 16*AnalogValue + Digit
NEXT
LET Char = FourDigitCmd
LET DPCode = DP2
GOTO RecCheck

Temp:
LET Bptr = TempMSB
GOSUB Ascii2BCD
IF AnalogValue < 4096 THEN
	LET Char = ThreeDigitCmd
ELSE
	LET Char = FourDigitCmd
ENDIF
LET DPCode = DP3
GOTO RecCheck

Humidity:
LET BPTR = HumMSB
GOSUB Ascii2BCD
LET Char = ThreeDigitCmd
LET DPCode = DP3
GOTO RecCheck

Altitude:
LET BPTR = AltMSB				'This ignores the TenThousands digit
IF @bptr > "0" AND @bptr <= "9" THEN	
	LET Char = FourDigitCmd
ELSE
	LET Char = ThreeDigitCmd
ENDIF
GOSUB Ascii2BCD
LET DPCode = DPnone
GOTO RecCheck

Barometer:
LET BPTR = BaroMSB
LET AnalogValue = 0
GOSUB Ascii2BCD
LET Char = FourDigitCmd
LET DPCode = DP2
GOTO RecCheck

Year:
LET AnalogValue = $2000
LET DSAddr = RTCYear
GOSUB GetByte			'Into Digit
LET AnalogValue = AnalogValue + Digit
LET Char = FourDigitCmd
LET DPCode = DPNone 
GOTO RecCheck

Range:
LET analogValue = AltRange
LET char = TwoDigitCmd
GOSUB DisplayNumber 
GOTO Record

AltAdjust:
READ AltAdjustAddr,analogvalue
LET char = ThreeDigitCmd
GOSUB DisplayNumber
GOTO Record


'Record if ready ---------------------------------------------------

RecCheck:
GOSUB DisplayDigits
Record:
'Measure suply voltage just before recording
GOSUB GetVolt	
IF MinuteFlag = 0 OR RecordSW = 1  OR BaroReady = 0 OR MeasValue < MinVolts THEN 'Turn off LED, do not record
	LET Digit = 4*BaroFlag
	GOSUB SendHex	 
	HIGH DisplayNotCE	
	GOTO Main
ENDIF
LET MinuteFlag = 0	'Open 56 ms
HIGH SDCommand 
'Make a recording ;Time to end is 124 ms
LET bptr = YearMSB	'Now open a file. The SD is pre-written with year anf month folders
SEROUT SDCommand,T9600_16,("O 1 A /",@bptrinc,@bptrinc,"/",@bptrinc,@bptrinc,"/ML",@bptrinc,@bptr,".CSV",13)
SERIN  SDResponse,T9600_16,Char	
'Check if SD ready and present
IF Char = ">" THEN
	LET Digit = 8		'Light Red LED
ELSE
	LET Digit = 0
ENDIF
GOSUB SendHex		'Write 158 ms	 
HIGH DisplayNotCE		
GOSUB GetVolt	
IF MeasValue < MinVolts THEN close
IF Digit = 0 THEN main		'SD not present or properly prepared
SEROUT SDCommand,T9600_16,("W 1 57",13)	'Write date,time,Input Volts,Probe Temperature to the SD
IF HeaderFlag = 0 THEN
LET bptr = YearMSB
SEROUT SDCommand,T9600_16,("20",@bptrinc,@bptrinc,"/",@bptrinc,@bptrinc,"/",@bptrinc,@bptrinc)
SEROUT SDCommand,T9600_16,(",",@bptrinc,@bptrinc,":",@bptrinc,@bptr)
LET bptr = VoltMSB	'Supply voltage
SEROUT SDCommand,T9600_16,(",",@bptrdec,@bptrdec,".",@bptrdec,@bptr)
LET bptr = TempMSB	'Temperature and Humidity
SEROUT SDCommand,T9600_16,(",",@bptrdec,@bptrdec,@bptrdec,".",@bptrdec,",",@bptrdec,@bptrdec,@bptrdec,".",@bptr)
LET bptr = Alt5th	'Altitude, Barometric pressure 
SEROUT SDCommand,T9600_16,(",",@bptrdec,@bptrdec,@bptrdec,@bptrdec,@bptrdec,",",@bptrdec,@bptrdec,@bptrdec,".",@bptrdec,@bptr)
ELSE
	'SEROUT SDCommand,T9600_16,("Date,Time,Input Volts,I-Temp,Humidity,Altitude,Barometer")
	SEROUT SDCommand,T9600_16,("Date,Time,V,Tmp,Hum,Alt,Bar")
	LET HeaderFlag = 0
ENDIF
SEROUT SDCommand,T9600_16,(13,10)
SERIN  [300],SDResponse,T9600_16,(">")
close:
SEROUT SDCommand,T9600_16,("C 1",13)	'Close the file
GOTO Main
end

'Fourth-level subroutine
SendToRTC:			'1 Input is in RTCData
HIGH RTCEn
FOR BitPos = 0 TO 7
	LET MaskAddr = 8*LSBFst + BitPos
	READ MaskAddr,Mask
	LET Mask = RTCData & Mask	
	IF Mask = 0 THEN
		LOW RTCOut
	ELSE
		HIGH RTCOut
	ENDIF
	PULSOUT Clock,1
NEXT
INPUT RTCout
RETURN

'Third Level Subroutines -----------------------------------

SendByte:		      '2 Address in DsAddr, data in Digit
LET RTCData = DSAddr
LET LSBFst = 1
GOSUB SendToRTC
IF DSAddr < $C0  THEN	'Not Humidity
	LET LSBFst = 1		'LSB first
ELSE
	LET LSBFst = 0			'MSB First	
ENDIF
PAUSE 1
LET RTCData = Digit
GOSUB SendToRTC
LOW RTCEn
RETURN

GetByte:			'3 Address is in DSAddr; data is returned in Digit
LET LSBFst = 1
LET RTCData = DSAddr	
GOSUB SendToRTC
IF DSAddr < $C0  THEN	'Not Humidity
	LET LSBFst = 1		'LSB first
ELSE
	LET LSBFst = 0			'MSB First	
ENDIF
INPUT RTCout
LET Digit = 0
FOR BitPos = 0 TO 7
	IF RTCIn = 1 THEN
		LET MaskAddr = 8*LSBFst + BitPos
		READ MaskAddr,Mask
		LET Digit = Digit + Mask
	ENDIF
PULSOUT Clock,1
NEXT 
LOW RTCEn
RETURN


SendHex:					'4						
FOR MaskAddr = 4 TO 7
	READ MaskAddr,Mask
	LET Mask = Digit & Mask
	LOW DisplayData
	IF Mask = 0 THEN HexBitisLow
	HIGH DisplayData
HexBitisLow:
	PULSOUT Clock,1
NEXT
RETURN

'Second Level subroutines ------------------------------------------

DisplayDigits:				'5
LOW Clock
LOW DisplayNotCE
IF Char = AllAlphaCmd THEN
	LET Digit = AllAlphaCmd
ELSE
	LET Digit = Cmd4MSB
ENDIF
GOSUB SendHex
LET Digit = Char 
GOSUB SendHex
PULSOUT DisplayNotCE,10
LET Digit = 8*Bright + DPCode
GOSUB SendHex
FOR Scratch = 0 TO 3
	LET Digit = AnalogValue // 16
	GOSUB SendHex 
	LET AnalogValue = AnalogValue / 16
NEXT
RETURN

StoreAnalog:
FOR Index = 0 TO 3
	IF Index = 3 AND MinusFlag = 1 THEN
		LET @bptrinc = "-"
	ELSE
		LET @bptrinc = AnalogValue // 10 + "0"
	ENDIF
	LET AnalogValue = AnalogValue / 10
NEXT
IF bptr = Alt5th THEN			'Only Altitude may have 5 figures
	IF AnalogValue > 0 AND AnalogValue <= 9 THEN
		LET @bptr = AnalogValue  + "0"
	ELSEIF MinusFlag = 1 THEN
		LET @bptr = " "
	ELSE
		LET @bptr = "0"								'8/24/2018 was " "
	ENDIF
ENDIF
RETURN

Ascii2BCD:			'7: Enter with the bit pointer address of the most significant digit
LET AnalogValue = 0
FOR Scratch = 0 TO 3
	LET Digit = @bptrdec - "0"
	LET AnalogValue = 16*AnalogValue + Digit
NEXT
RETURN			'The 4 BCD numbers as a word
#rem
SendWord:			'First byte is MS byte in binary, Input in AnalogValue
LET Digit = AnalogValue / 256
GOSUB SendByte
LET Digit = AnalogValue // 256
LET DSAddr = DSAddr + 2
GOSUB SendByte
RETURN

GetWord:			'First byte is MS byte in binary, Input in AnalogValue
GOSUB GetByte
LET AnalogValue = 256*Digit
LET DSAddr = DSAddr + 2
GOSUB GetByte
LET AnalogValue = Digit + AnalogValue
RETURN
#endrem

' First Level subroutines ---------------------------------------------

AdjTimeDate:		'8 Entry is DSAddr and Limit
GOSUB GetByte		'Get existing value into Digit
LET Scratch = Digit/16
LET Digit = Digit//16
LET Digit =  10*Scratch + Digit
IF UpDown > 45 THEN
	INC Digit
ELSE	
	DEC Digit
ENDIF
IF Digit > Limit THEN
	LET Digit = 1
ENDIF	
IF Digit = 0 THEN
	LET Digit = Limit
ENDIF	
LET Scratch = Digit/10 
LET Digit = Digit // 10
LET Char = 16*Scratch + Digit
LET Scratch = DSAddr - 1
LET DSAddr = RTCWP
LET Digit = 0
GOSUB SendByte			'Enable writing the RTC
LET DSAddr = Scratch
LET Digit = Char
GOSUB SendByte			'Write changed data back into the RTC
LET DSAddr = RTCWP
LET Digit = 0
GOSUB SendByte			'Disable writing the RTC
RETURN

CelsiusToFarenheit:	
'1/1/2012
LET MeasValue = AnalogValue & $8000
IF MeasValue = 0 THEN TempIsPositive
LET MinusFlag = 1
IF Char = 5 THEN					'1;8;12
	LET AnalogValue = AnalogValue & $7FFF	'Sensor uses Sign & Magnitude
ELSE
	LET AnalogValue = AnalogValue ^ $FFFF + 1	'Convert 2's complement to signed positive
ENDIF

TempIsPositive:
LET AnalogValue = 9*AnalogValue/Char 'in tenths of deg F 1/8/12
IF MinusFlag = 1 THEN
	LET AnalogValue = 320 - AnalogValue
ELSE
	LET AnalogValue = 320 + AnalogValue
ENDIF
LET MinusFlag = 0			'Because the converted value is positive (usually)

RETURN

GetHumTemp:				'9 Gets the integer value from RTC into AnalogValue
GOSUB GetByte 
LET AnalogValue = Digit	
LET DSAddr = DSAddr + 2
GOSUB GetByte  
LET AnalogValue = 256*AnalogValue + Digit
RETURN

GetHumidity:			'10
'Get the data from the Humidity/Temperature sensor into the RTC RAM by hardware
LET DSAddr = RTCWP
LET Digit = 0
GOSUB SendByte			'Enable writing the RTC
LET LSBFst = 1
LET RTCData = RAMBurst
GOSUB SendToRTC
FOR Scratch = 0 TO PreClock		'Send extra bytes to the RAM because of extra clock pulses
	PULSOUT Clock, 1	
NEXT
INPUT  RTCOut			'Now trigger the Humidity device
INPUT Clock
PULSOUT Sync, 320
PAUSE 40	'10 ms at m16. The Humidity sensor takes 6ms to write 5 bytes to the RTC RAM		
LET DSAddr = RTCWP
LET Digit = 0
GOSUB SendByte			'Disable writing the RTC

'GetHumidity from the RTC RAM and put into the scratchpad
LET DSAddr = HumAddr
GOSUB GetHumTemp		'Into AnalogValue, with processing
LET bptr = HumLSB
GOSUB StoreAnalog

'GetInternal temperature:from the RTC and put into the scratchpad 
LET DSAddr = TempAddr
GOSUB GetHumTemp
LET Char = 5			'1/8/12
GOSUB CelsiusToFarenheit
LET bptr = TempLSB
GOSUB StoreAnalog
RETURN

Transmit:			'8/24/2018
#rem Transmits Altitude AltMSB - AltLSB (61 - 58),Temperature TempMSB - TempLSB (53 - 50), Humidity HumMSB - HumLSB (49 - 46),
Supply Voltage VoltsMSB - VoltsLSB (45 - 42) No decimal points, 3 commas ( 3x44 = 132). 4 digits + 3 commas = 19 + 60 = 79 "O"
Calculating checksum in digit
#endrem 
LET Digit = 3 * ","
FOR bptr = VoltLSB TO TempMSB			'12 characters
	LET Digit = Digit + @bptr
NEXT
FOR bptr = AltLSB TO Alt5Th			'8/24/2008 5 characters
'FOR bptr = AltLSB TO AltMSB			'4 characters
	LET Digit = Digit + @bptr
NEXT
LET Char = Digit / 16
IF Char < 10 THEN
	LET Char = Char + "0"
ELSE
	LET Char = Char + "7"
ENDIF
POKE ChkMSB,Char
LET Char = Digit & $F
IF Char < 10 THEN
	LET Char = Char + "0"
ELSE
	LET Char = Char + "7"
ENDIF
POKE ChkLSB,Char
SETFREQ m8
High TxPort
PAUSE 40
LOW TxPort
PAUSE 20
'LET bptr = AltMSB
LET bptr = Alt5th							'8/24/2008
SEROUT TxPort,N2400_8,("14L1776w,P,",@bptrdec,@bptrdec,@bptrdec,@bptrdec,@bptr)		'8/24/2008
'SEROUT TxPort,N2400_8,("14L1776w,O,",@bptrdec,@bptrdec,@bptrdec,@bptr)
LET bptr = TempMSB
SEROUT TxPort,N2400_8,(",",@bptrdec,@bptrdec,@bptrdec,@bptrdec,",",@bptrdec,@bptrdec,@bptrdec,@bptrdec,",",@bptrdec,@bptrdec,@bptrdec,@bptr)
LET bptr = ChkMSB
SEROUT TxPort,N2400_8,(",",@bptrdec,@bptr,13,10,4)	'Pad added 10/8/2018
'LET bptr = Alt5Th
'SERTXD (@bptrdec,@bptrdec,@bptrdec,@bptrdec,@bptr)
'LET bptr = TempMSB
' SERTXD (",",@bptrdec,@bptrdec,@bptrdec,@bptrdec,",",@bptrdec,@bptrdec,@bptrdec,@bptrdec,",",@bptrdec,@bptrdec,@bptrdec,@bptrdec,",",@bptrdec,@bptr,13,10)
SETFREQ m16
RETURN

GetVolt:			'1/1/12
'Time to read & store input volts is 5 ms
FVRSETUP FVR4096			'For input voltage measurement
ADCCONFIG 3       'Ref is internal
READADC10  MeasValuePort,MeasValue
LET AnalogValue = 2*MeasValue		'20 volts full scale = 2000
LET bptr = VoltLSB
GOSUB StoreAnalog
RETURN

GetDateTime:	'12
'Time to here is 22 ms, time to read time & date is 97 ms, leaves with digit = minutes
LET bptr = YearMSB
FOR Scratch = 0 TO 4
	LOOKUP Scratch,(RTCYear,RTCMonth,RTCDate,RTCHour,RTCMin),DSAddr
	GOSUB GetByte
	LET Char = Digit / 16 + "0"
	LET @bptrinc = Char
	LET Char = Digit // 16 + "0"
	LET @bptrinc = Char
NEXT
RETURN


'Measure Pressure from the sensor and put into the scratchpad
GetPressure:
ADCCONFIG 0       		'Ref is Vcc
READADC10  Baro,MeasValue
IF BaroCount = 0 THEN	'Find out the range and therefore multiplier
	LET AltRange = 5
	FOR index = 0 TO 4
	LET char = 2*index + AltCrossoverAddr
		READ char,WORD analogvalue
		IF MeasValue > AnalogValue THEN
			LET AltRange = index
			EXIT
		ENDIF
	NEXT
ENDIF

LET BaroValue = BaroValue + MeasValue 'Doing the multiplication
INC BaroCount				
LET Scratch = AltRange + 12 

IF BaroCount = Scratch THEN		'Reached the Altitude multiplier, store value
	LET RawAltitude = BaroValue	'This is displayed every loop
	IF Mode > 0 THEN
		LET BaroFlag = 1		'Lights green LED
	ENDIF
ENDIF

LET Char = 2*AltRange + AltOffsetAddr	'Get the feet value to display
READ Char,WORD analogValue			'Offset value	
READ AltAdjustAddr,digit			'The altitude adjustment
LET analogValue = 4*digit + analogvalue - 512 - RawAltitude
IF analogValue > 32000 THEN		'Below sea level
	LET analogValue = 65535 - analogValue
	LET MinusFlag = 1
ENDIF
LET bptr = AltLSB
GOSUB StoreAnalog
LET MinusFlag = 0


rem Now for the barometer, which has fixed parameters
IF BaroCount >= BaroMult THEN			'This is always greater than the Altitude multiplier
	LET BaroCount = 0
	LET AnalogValue = BaroValue/BaroDiv + BaroSetting
	LET bptr = BaroLSB
	GOSUB StoreAnalog
	LET BaroValue = 0
	LET BaroFlag = 0
	LET BaroReady = 1
ENDIF
RETURN

DisplayNumber:				'displays the value in analogValue
LOW Clock
LOW DisplayNotCE
LET Digit = Cmd4MSB
GOSUB SendHex
LET Digit = char 
GOSUB SendHex
PULSOUT DisplayNotCE,10
LET Digit = DPNone
GOSUB SendHex
FOR Scratch = 0 TO 3
	LET Digit = AnalogValue //10 + "0"
	GOSUB SendHex 
	LET AnalogValue = AnalogValue / 10
NEXT
RETURN
